// orderedArray.java
// demonstruje tablic uporzdkowan
// uruchomienie programu: C>java OrderedApp
////////////////////////////////////////////////////////////////
class OrdArray
   {
   private long[] a;                 // referencja do tablicy 
   private int nElems;               // liczba elementw tablicy 
   //-----------------------------------------------------------
   public OrdArray(int max)          // konstruktor 
      {
      a = new long[max];             // tworzymy tablic 
      nElems = 0;
      }
   //-----------------------------------------------------------
   public int size()
      { return nElems; }
   //-----------------------------------------------------------
   public int find(long searchKey)
      {
      int lowerBound = 0;              // ograniczenie dolne
      int upperBound = nElems-1;       // ograniczenie grne
      int curIn;                       // aktualnie sprawdzany indeks

      while(true)
         {
         curIn = (lowerBound + upperBound ) / 2;
         if(a[curIn]==searchKey)
            return curIn;              // znalelimy element
         else if(lowerBound > upperBound)
            return nElems;             // nie znalelimy go
         else                          // podzia przedziau
            {
            if(a[curIn] < searchKey)
               lowerBound = curIn + 1; // jest w grnej poowie
            else
               upperBound = curIn - 1; // jest w dolnej poowie
            }  // koniec podziau przedziau
         }  // koniec while
      }  // koniec find()
   //-----------------------------------------------------------
   public void insert(long value)    // wstawianie elementu do tablicy 
      {
      int j;
      for(j=0; j<nElems; j++)        // znajdujemy dla niego miejsce
         if(a[j] > value)            // (wyszukiwanie liniowe)
            break;
      for(int k=nElems; k>j; k--)    // przesuwamy wiksze elementy 
         a[k] = a[k-1];
      a[j] = value;                  // wstawiamy
      nElems++;                      // zwikszamy licznik elementw 
      }  // koniec insert()
   //-----------------------------------------------------------
   public boolean delete(long value)
      {
      int j = find(value);
      if(j==nElems)                  // nie znaleziono
         return false;
      else                           // znaleziono
         {
         for(int k=j; k<nElems; k++) // przesuwamy wiksze elementy
            a[k] = a[k+1];
         nElems--;                   // zmniejszamy licznik elementw 
         return true;
         }
      }  // koniec delete()
   //-----------------------------------------------------------
   public void display()             // wypisuje zawarto tablicy 
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         System.out.print(a[j] + " ");  // ...wypisujemy jego warto
      System.out.println("");
      }
   //-----------------------------------------------------------
   }  // koniec klasy OrdArray
////////////////////////////////////////////////////////////////
class OrderedApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;             // rozmiar tablicy 
      OrdArray arr;                  // referencja do tablicy 
      arr = new OrdArray(maxSize);   // tworzymy tablic 

      arr.insert(77);                // wstawiamy 10 elementw 
      arr.insert(99);
      arr.insert(44);
      arr.insert(55);
      arr.insert(22);
      arr.insert(88);
      arr.insert(11);
      arr.insert(00);
      arr.insert(66);
      arr.insert(33);

      int searchKey = 55;            // wyszukiwanie elementu 55
      if( arr.find(searchKey) != arr.size() )
         System.out.println("Znaleziono " + searchKey);
      else
         System.out.println("Nie znaleziono " + searchKey);

      arr.display();                 // wypisujemy zawarto tablicy 

      arr.delete(00);                // usuwamy trzy elementy 
      arr.delete(55);
      arr.delete(99);

      arr.display();                 // wypisujemy zawarto tablicy 
      }  // koniec main()
   }  // koniec klasy OrderedApp
